%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Function name: plot_ref_conditions
%
% Scope:    plot overview figure with mean/std deviation of each interval
%
% Input:    data (structure),
%           bindata (structure),
%           binref (structure),
%           list of gas names (cell)
%
% Output:   overview figure with mean/std deviation
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function plot_ref_conditions(data,bindata,binref,gasnames)

tic;fprintf('Running function plot_ref_conditions...\n');

plotvars_bin=[2 6 4 12 5 14];    

figure;
for i=1:6
    subplot(3,2,i);
    hold on;
    for k=1:width(gasnames)
        scatter(bindata.(gasnames{1,k})(:,1),bindata.(gasnames{1,k})(:,plotvars_bin(1,i)),10);
    end
    errorbar(binref.mean(:,1),binref.mean(:,plotvars_bin(1,i)),binref.std(:,plotvars_bin(1,i)),'marker','o','linestyle','none','color','k','markeredgecolor','k','markerfacecolor','none','linewidth',1.2);
    grid on;
    box on;
    xlim([0 data.all(end,1)-bindata.start_time]);
    ylabel({sprintf('%s',bindata.varlabels{1,plotvars_bin(1,i)})},'fontsize',12);
    if i==5 || i==6
    xlabel('Time [h]','fontsize',12); end
    if i==1
    title('Overview mean values \pm 1 \sigma','fontsize',12); end
    if i==6
        lll=cell(1,width(gasnames));
        for n=1:width(gasnames)
            lll{n} = string(gasnames{1,n}); end
        legend(lll,'location','northeast');
    end
end

    x0 = 10;
    y0 = 50;
    ww = 900;
    hh = 700;
    set(gcf,'units','points','position',[x0,y0,ww,hh]);
    set(gcf,'Units','Inches');
    pos = get(gcf,'Position');
    set(gcf,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3),pos(4)]);

time_elapsed=toc; fprintf('plot_ref_conditions completed (execution time: %1.2f s)\n',time_elapsed);

end

